<?php

namespace App\Http\Controllers\SiteGroup\Settings;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Site\SiteInfo;
use App\Models\SiteGroup\GlobalSiteGroupSetting;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicGroup;
use App\Models\Academic\AcademicSubject;
use App\Models\Academic\AcademicSubjectClassExamCondition;
use App\Models\Academic\SubjectCondition;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Site\GlobalSiteShiftClassGroupSectionSetting;
use App\Models\SubjectGroupConditionSetting\GlobalSiteSubjectConditionLimit;
use App\Models\SubjectGroupConditionSetting\GlobalSubjectGroupConditionSetting;
use App\Models\SiteGroup\Settings\SiteGroupSubjectGroupConditionSettingStore;
use App\Models\SiteGroup\Settings\SiteGroupShiftClassGroupSectionSettingStore;
use App\Models\SiteGroup\Settings\SiteGroupAcademicSettingsStore;
use App\Models\SiteGroup\Settings\SiteGroupSiteSubjectConditionLimitStore;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Http\Controllers\SiteGroup\SiteGroupProjectController;

use Response;
use Session;
use Exception;

class SiteGroupAcademicSubjectSettingController extends SiteGroupProjectController
{
    private $subjectCondition, $academicClassGroup,
    $academicSubject, $siteGroupSubjectGroupConditionSettingStore;

    public function __construct(
     SubjectCondition $subjectCondition,
     AcademicClassGroup $academicClassGroup,
     AcademicSubject $academicSubject,
     SiteGroupSubjectGroupConditionSettingStore $siteGroupSubjectGroupConditionSettingStore
     )
    {
        $this->middleware('auth');
        $this->middleware('sitegrouppagechecker');
        $this->subjectCondition = $subjectCondition;
        $this->academicClassGroup = $academicClassGroup;
        $this->academicSubject = $academicSubject;
        $this->siteGroupSubjectGroupConditionSettingStore = $siteGroupSubjectGroupConditionSettingStore;
    }

    public function index()
    {
        $viewType = "Site Group Subject Settings";
        return view('default.admin.layouts.master', compact('viewType'));
    }


    public function getSiteGroupYearDepartmentClassList()
    {

        $site_group_info_setting = GlobalSiteGroupSetting::where('site_group_id',Session::get('SITE_GROUP_ID'))->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))->first();

        $academicDepartmentList = [];
        $academicClassList = [];
        $academicYearList = null;

        $academic_year_ids = explode(',', $site_group_info_setting->academic_year_ids) ?? null;
        $academicYearList = AcademicYear::select('id', 'year_name')
            ->whereIn('id', $academic_year_ids)
            ->orderBy('id','DESC')
            ->get();

        if ($site_group_info_setting->academic_department_ids) {
            $academicDepartment = explode(',', $site_group_info_setting->academic_department_ids) ?? null;
            $academicDepartmentList = AcademicDepartment::select('id', 'name as department_name')
                ->whereIn('id', $academicDepartment)->get();
        } else {
            $academicClass = explode(',', $site_group_info_setting->academic_class_ids) ?? null;
            $academicClassList = AcademicClass::select('id', 'class_name')
                ->whereIn('id', $academicClass)
                ->orderBy('serial_no', 'ASC')
                ->get();
        }

        $siteList=GlobalSiteInfo::select('id')
        ->whereIn('id',$this->siteIds())
        ->get();

        $s_List=[];
        foreach($siteList as $key=>$item){
            $s_List[$key]['id']=$item->id;
            $s_List[$key]['site_name']=$item->site_name;
            $s_List[$key]['select']=false;
        }

       // dd($academicYearList);

        return [$academicClassList, $academicDepartmentList, $academicYearList, $s_List];

    }


    public function getSiteGroupSubjectConditionList($class_id, $department_id, $year_id){

        try {

    $department_id = $department_id == 'null' ? null : $department_id;
    $year_id = $year_id == 'null' ? null : $year_id;
    $class_id = $class_id == 'null' ? null : $class_id;


    if (!$class_id || !$year_id) {
        return Response::json(['message' => 'Select * Marked Field!'], 410);
    }
    //site_group_info_setting

    $sGroupCondSettings = SiteGroupSubjectGroupConditionSettingStore::with(['academicClass', 'academicSubject'])
        ->where('academic_class_id', $class_id)
        ->where('academic_year_id', $year_id)
        ->when($department_id, function ($query) use ($department_id) {
            return $query->where('academic_department_id', $department_id);
        })
        ->where('status', true)
        ->get();

 // $site_group_info_setting = GlobalSiteGroupSetting::first();
  $site_group_info_setting = SiteGroupAcademicSettingsStore::first();

  $site_academic_subject_ids = GlobalSubjectGroupConditionSetting::whereIn('site_id',$this->siteIds())
        ->where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
        ->where('academic_class_id', $class_id)
        ->where('academic_year_id', $year_id)
        ->when($department_id, function ($query) use ($department_id) {
            return $query->where('academic_department_id', $department_id);
        })
        ->where('status', true)
       // ->groupBy('site_id')
        ->pluck('academic_subject_id')
        ->unique();

    $final = [];
    if (count($sGroupCondSettings)) {

        $editMode = true;
        //=======================================================================
        //for getting subject from site_info table

        $subjectIds = $site_group_info_setting->academic_subject_ids ?? null;
        $subjectIdsArray = explode(',', $subjectIds) ?? [];

        $academic_class_group = $site_group_info_setting->academic_class_group_ids ?? null;
        $class_group_ids = explode(',', $academic_class_group) ?? [];
        //=========================================================================
// <<<<<<< HEAD
        
//         $accClass = AcademicClass::with(['subjects' => function ($query) use ($subjectIdsArray, $site_academic_subject_ids) {
//                     $query->whereIn('academic_subjects.id', $subjectIdsArray)
//                         ->whereIn('academic_subjects.id', $site_academic_subject_ids);
//                     }])
//                 ->findOrFail($class_id);//academic_subject_condition_ids
// =======

//         $accClass = AcademicClass::with(['subjects' => function ($query) use ($subjectIdsArray, $department_id) {
//             $query->whereIn('academic_subjects.id', $subjectIdsArray);
//         }])->findOrFail($class_id);//academic_subject_condition_ids
// >>>>>>> master

        
        // $accClass = AcademicClass::with(['subjects' => function ($query) use ($subjectIdsArray, $site_academic_subject_ids) {
        //             $query->whereIn('academic_subjects.id', $subjectIdsArray)
        //                 ->whereIn('academic_subjects.id', $site_academic_subject_ids);
        //             }])
        //         ->findOrFail($class_id);


        $accClass = AcademicClass::with(['subjects' => function ($query) use ($subjectIdsArray, $department_id) {
            $query->whereIn('academic_subjects.id', $subjectIdsArray);
        }])->findOrFail($class_id);




        $subject_list_for_dependance=$accClass->subjects;

        $subCon = $this->subjectCondition->whereIn('id', explode(',', $site_group_info_setting->academic_subject_condition_ids ?? null))->get();

        $acGr = $this->academicClassGroup->whereIn('id', $class_group_ids)->get();

        $subject_class_exam_list = AcademicSubjectClassExamCondition::
            whereIn('id', explode(',', $site_group_info_setting->academic_subject_class_exam_condition_ids ?? null))
            ->get();

        foreach ($accClass->subjects as $k => $value) {

            $subjectArr = Array();
            $subjectConditionArr = Array();
            $mergedSubjectCondition = [];
            $subjectGroupArr = Array();
            $subjectGroupGroup = [];
            $sub_id = $value->id;
            $subjectClassExamArr=Array();
            $subjectClassExamArray=[];
            $sub = SiteGroupSubjectGroupConditionSettingStore::whereAcademicSubjectId($sub_id)
                ->where('academic_class_id', $class_id)
                ->where('academic_year_id', $year_id)
                ->when($department_id, function ($query) use ($department_id) {
                    return $query->where('academic_department_id', $department_id);
                })
                ->where('status', true)
                ->first();

            $subjectArr['checked'] = $sub ? true : false;
            $subjectArr['subject_code'] = $sub->subject_code ?? "";

            foreach ($subCon as $keyCond => $condition) {
                $dd = in_array($condition->id, explode(',', $sub->academic_subject_condition_ids ?? null));
                $subjectConditionArr['checked'] = $dd;
                $mergedSubjectCondition[$keyCond] = array_merge($subjectConditionArr, $condition->toArray());
            }

            if ($accClass->academic_group_present == 1) {

                foreach ($acGr as $key => $group) {

                    $isFound = in_array($group->id, explode(',', $sub->academic_class_group_ids ?? null));
                    $subjectGroupArr['checked'] = $isFound;
                    $subjectGroupGroup[$key] = array_merge($subjectGroupArr, $group->toArray());

                }
            }


            $mergedSubject = array_merge($subjectArr, $value->toArray());

            $final[$k] = $mergedSubject;
            $final[$k]['subCon'] = $mergedSubjectCondition;
            $final[$k]['acGr'] = $subjectGroupGroup;
            $final[$k]['subjectClassExamList'] = $subject_class_exam_list;
            $final[$k]['checkedRadio'] = $sub['academic_subject_class_exam_condition_id'] ?? null;
            $final[$k]['result_show_in_table_bellow'] = $sub['result_show_in_table_bellow']?? false;
            $final[$k]['subject_position'] = $sub['subject_position'] ?? 0;

            $final[$k]['exam_dependent_academic_subject_id'] =$sub_id?$sub_id:$sub['exam_dependent_academic_subject_id'];
        }


    } else {


        $editMode = false;
        //=======================================================================
        //for getting subject from site_info table

        $subjectIds = $site_group_info_setting->academic_subject_ids ?? null;
        $subjectIdsArray = explode(',', $subjectIds) ?? [];
        $subjects = $this->academicSubject->whereIn('id', $subjectIdsArray)->get();
        //=========================================================================

        $accClass = AcademicClass::with(['subjects' => function ($query) use ($subjectIdsArray, $department_id) {
            $query->whereIn('academic_subjects.id', $subjectIdsArray);
        }])->findOrFail($class_id);

        $subCon = $this->subjectCondition
            ->whereIn('id', explode(',', $site_group_info_setting->academic_subject_condition_ids ?? null))
            ->get();

        $subject_list_for_dependance=$accClass->subjects;

        $acGr =  $this->academicClassGroup->whereIn('id', explode(',', $site_group_info_setting->academic_class_group_ids ?? null))->get();

        $subject_class_exam_list = AcademicSubjectClassExamCondition::
        whereIn('id', explode(',', $site_group_info_setting->academic_subject_class_exam_condition_ids ?? null))
            ->get();

        foreach ($accClass->subjects as $k => $value) {
            $subjectArr = Array();
            $subjectConditionArr = Array();
            $mergedSubjectCondition = [];
            $subjectGroupArr = Array();
            $subjectGroupGroup = [];
            $sub_id = $value->id;
            $sub = '';
            $subjectArr['checked'] = false;
            $subjectArr['status'] = "1";
            $subjectArr['subject_code'] = "";

            $subjectClassExamArr=Array();
            $subjectClassExamArray=[];

            foreach ($subCon as $keyCond => $condition) {
                $dd = in_array($condition->id, explode(',', $sub->academic_subject_condition_ids ?? null));
                $subjectConditionArr['checked'] = $dd;
                $mergedSubjectCondition[$keyCond] = array_merge($subjectConditionArr, $condition->toArray());
            }

            if ($accClass->academic_group_present == 1) {
                foreach ($acGr as $key => $group) {
                    $isFound = in_array($group->id, explode(',', $sub->academic_class_group_ids ?? null));
                    $subjectGroupArr['checked'] = $isFound;
                    $subjectGroupGroup[$key] = array_merge($subjectGroupArr, $group->toArray());
                }
            }

            $mergedSubject = array_merge($subjectArr, $value->toArray());
            $final[$k] = $mergedSubject;
            $final[$k]['subCon'] = $mergedSubjectCondition;
            $final[$k]['acGr'] = $subjectGroupGroup;
            $final[$k]['subjectClassExamList'] = $subject_class_exam_list;
            $final[$k]['result_show_in_table_bellow'] = false;
            $final[$k]['subject_position'] = 0;
            $final[$k]['checkedRadio'] = 0;

            $final[$k]['exam_dependent_academic_subject_id'] =$sub_id;
        }

    }

    $examTestArray=$final;

    // existing site ids
    if (count($sGroupCondSettings)) {
        $existing_site_ids = GlobalSubjectGroupConditionSetting::whereIn('site_id',$this->siteIds())
            ->where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
            ->where('academic_class_id', $class_id)
            ->where('academic_year_id', $year_id)
            ->when($department_id, function ($query) use ($department_id) {
                return $query->where('academic_department_id', $department_id);
            })
            ->where('status', true)
            ->groupBy('site_id')
            ->pluck('site_id');
        }else{
            $existing_site_ids=[];
        }

         return [$examTestArray, $editMode, $sGroupCondSettings, $subject_list_for_dependance, $existing_site_ids];
       } catch (Exception $exception) {
           return $exception->getMessage();

       }
    }



    public function getSiteGroupYearVersionBaseDepartmentClass($version_id, $year_id)
    {


        $academicClassList = [];
        $academicDepartmentList = [];

        $site_group_id     = Session::get('SITE_GROUP_ID');
        $academic_group_id = Session::get('ACADEMIC_GROUP_ID');
        $site_ids          = $this->siteIds();


         $academicClass_ids = GlobalSiteShiftClassGroupSectionSetting::
            whereIn('site_id', $site_ids)
            ->where('academic_group_id', $academic_group_id)
            ->where('academic_year_id', $year_id)
            ->groupBy('academic_class_id')
            ->pluck('academic_class_id')
            ->unique();


         $academicClassList = AcademicClass::whereIn('id', $academicClass_ids)
            ->orderBy('serial_no', 'ASC')
            ->get();

        return [$academicClassList, $academicDepartmentList];
       }

    public function getSiteGroupYearVersionClassBaseGroup($version_id,$year_id,$shift_id,$class_id)
    {
    
       // dd($version_id);

        $academicClassList = [];
        $academicDepartmentList = [];

        $site_group_id=Session::get('SITE_GROUP_ID');
        $academic_group_id=Session::get('ACADEMIC_GROUP_ID');
        $site_ids=$this->siteIds();
        $site_group_info_setting = SiteGroupAcademicSettingsStore::first();
        
        $academicClassGroup_ids = GlobalSiteShiftClassGroupSectionSetting::
            whereIn('site_id', $site_ids)
            ->where('academic_group_id', $academic_group_id)
            ->where('academic_year_id', $year_id)
            //->groupBy('academic_class_id')
            ->pluck('academic_class_group_id')
            ->unique();

           // dd($academicClassGroup_ids);

            if(count($academicClassGroup_ids)>=0){
            $academicClassGroup_ids=explode(',',$site_group_info_setting->academic_class_group_ids);

            }

        $academicClassList = AcademicClassGroup::whereIn('id', $academicClassGroup_ids)
         //   ->orderBy('serial_no', 'ASC')
            ->get();

        return [$academicClassList];
       }

       public function siteGroupSubjectConditionAdd(Request $request){


            $this->validate($request, [
                'academic_class_id' => 'required',
            ]);

            // if(collect($request->site_ids)->count() <= 0){
            //     return Response::json(['message' => 'Institute is null'],401);
            // }

            $site_group_id=Session::get('SITE_GROUP_ID');
            $academic_group_id=Session::get('ACADEMIC_GROUP_ID');

            $class_id = $request->academic_class_id;
            $department_id = $request->academic_department_id;
            $year_id = $request->academic_year_id;
            $subjects = $request->finalSubjectListArr;
            $edit_mode = $request->editMode ? 'Updated' : 'Saved';
            $unchecked_subject_ids = [];
            $checked_subject_names = [];
            $unchecked_exam_ids = [];
            $unchecked_exam_type_ids=[];
            $stteIds=$this->siteIds();

            if (count($subjects) > 0) {

                ////===group stor start===

                foreach ($subjects as $key => $val) {
                    if ($val['checked']) {//if the subject is checked

                        $this->siteGroupSubjectGroupConditionSettingStore = new SiteGroupSubjectGroupConditionSettingStore();

                        $checked_subject_names[] = $val['subject_name'];
                        $subject_id = $val['id'];
                        $status = $val['checked'];
                        $subject_code = $val['subject_code'];
                        $subConditionIds = [];
                        $subGroupIds = [];

                    //subject Conditions
                        if (count($val['subCon']) > 0) {
                            $condArr = [];
                            foreach ($val['subCon'] as $conKey => $condVal) {
                                if ($condVal['checked']) {
                                    $condArr[] = $condVal['id'];
                                }
                            }
                            $subConditionIds = implode(",", $condArr);;
                        }
                        //subject Groups
                        $subGroupIds = null;
                        if (count($val['acGr']) > 0) {
                            $grArr = [];
                            foreach ($val['acGr'] as $conKey => $condVal) {
                                if ($condVal['checked']) {
                                    $grArr[] = $condVal['id'];
                                }
                            }
                            $subGroupIds = implode(",", $grArr);
                        }

                        $siteGroupSubjectAndClassExist = SiteGroupSubjectGroupConditionSettingStore::where('academic_subject_id', $subject_id)
                            ->where('academic_class_id', $class_id)
                            ->where('academic_year_id', $year_id)
                            ->when($department_id, function ($query) use ($department_id) {
                                return $query->where('academic_department_id', $department_id);
                            })
                            ->first();


                        if ($siteGroupSubjectAndClassExist) {
                        //    $SubjectGroupConditionSettingID=$siteGroupSubjectAndClassExist->id;

                            $siteGroupSubjectAndClassExist->update([
                                'academic_subject_condition_ids' => $subConditionIds,
                                'academic_class_group_ids' => $subGroupIds,
                                'academic_subject_class_exam_condition_id' => $val['checkedRadio'],
                                'exam_dependent_academic_subject_id' => $val['exam_dependent_academic_subject_id'],
                                'subject_position' => $val['subject_position']??0,
                                'result_show_in_table_bellow' => $val['result_show_in_table_bellow']??false,
                                'subject_code' => $subject_code,
                                'status' => true
                            ]);

                        } else {

                            $this->siteGroupSubjectGroupConditionSettingStore->create([
                                'site_group_id' => $site_group_id,
                                'academic_group_id' => $academic_group_id,
                                'academic_class_id' => $class_id,
                                'academic_year_id' => $year_id,
                                'academic_department_id' => $department_id,
                                'academic_subject_id' => $subject_id,

                                'academic_subject_condition_ids' => $subConditionIds,
                                'academic_class_group_ids' => $subGroupIds,
                                'academic_subject_class_exam_condition_id' => $val['checkedRadio'],
                                'exam_dependent_academic_subject_id' => $val['exam_dependent_academic_subject_id'],
                                'subject_position' => $val['subject_position']??0,
                                'result_show_in_table_bellow' => $val['result_show_in_table_bellow']??false,
                                'subject_code' => $subject_code,
                                'status' => true
                            ]);

                        }

                       ///=== site condition start====


                    //     foreach($request->site_ids as $key=>$site_id){
                    //        if($site_id){

// <<<<<<< HEAD
//                     //         $siteSubjectAndClassExist = GlobalSubjectGroupConditionSetting::where('academic_subject_id', $subject_id)
//                     //         ->where('academic_group_id', $academic_group_id)
//                     //         ->where('site_id', $site_id)
//                     //         ->where('academic_class_id', $class_id)
//                     //         ->where('academic_year_id', $year_id)
//                     //         ->when($department_id, function ($query) use ($department_id) {
//                     //             return $query->where('academic_department_id', $department_id);
//                     //         })
//                     //         ->first();
    
//                     //     if ($siteSubjectAndClassExist) {
    
//                     //         $siteSubjectAndClassExist->update([
//                     //             'academic_subject_condition_ids' => $subConditionIds,
//                     //             'academic_class_group_ids' => $subGroupIds,
//                     //             'academic_subject_class_exam_condition_id' => $val['checkedRadio'],
//                     //             'exam_dependent_academic_subject_id' => $val['exam_dependent_academic_subject_id'],
//                     //             'subject_position' => $val['subject_position']??0,
//                     //             'result_show_in_table_bellow' => $val['result_show_in_table_bellow']??false,
//                     //             'subject_code' => $subject_code,
//                     //             'status' => true
//                     //         ]);
    
//                     //     } else {
//                     //         GlobalSubjectGroupConditionSetting::create([
//                     //             'site_id'=>$site_id,
//                     //             'academic_group_id'=>$academic_group_id,
//                     //             'academic_class_id'=>$class_id,
//                     //             'academic_year_id'=>$year_id,
//                     //             'academic_department_id'=>$department_id,
//                     //             'academic_subject_id'=>$subject_id,
//                     //             'academic_subject_condition_ids'=>$subConditionIds,
//                     //             'academic_class_group_ids'=>$subGroupIds,
//                     //             'academic_subject_class_exam_condition_id'=>$val['checkedRadio'],
//                     //             'exam_dependent_academic_subject_id'=>$val['exam_dependent_academic_subject_id'],
//                     //             'subject_code'=>$subject_code,
//                     //             'subject_position'=>$val['subject_position']??0,
//                     //             'result_show_in_table_bellow'=>$val['result_show_in_table_bellow']??false,
//                     //             'status'=>true,
//                     //         ]);
                             
//                     //     }
// =======
                        //     $siteSubjectAndClassExist = GlobalSubjectGroupConditionSetting::where('academic_subject_id', $subject_id)
                        //     ->where('academic_group_id', $academic_group_id)
                        //     ->where('site_id', $site_id)
                        //     ->where('academic_class_id', $class_id)
                        //     ->where('academic_year_id', $year_id)
                        //     ->when($department_id, function ($query) use ($department_id) {
                        //         return $query->where('academic_department_id', $department_id);
                        //     })
                        //     ->first();

                        // if ($siteSubjectAndClassExist) {

                        //     $siteSubjectAndClassExist->update([
                        //         'academic_subject_condition_ids' => $subConditionIds,
                        //         'academic_class_group_ids' => $subGroupIds,
                        //         'academic_subject_class_exam_condition_id' => $val['checkedRadio'],
                        //         'exam_dependent_academic_subject_id' => $val['exam_dependent_academic_subject_id'],
                        //         'subject_position' => $val['subject_position']??0,
                        //         'result_show_in_table_bellow' => $val['result_show_in_table_bellow']??false,
                        //         'subject_code' => $subject_code,
                        //         'status' => true
                        //     ]);

                        // } else {
                        //     GlobalSubjectGroupConditionSetting::create([
                        //         'site_id'=>$site_id,
                        //         'academic_group_id'=>$academic_group_id,
                        //         'academic_class_id'=>$class_id,
                        //         'academic_year_id'=>$year_id,
                        //         'academic_department_id'=>$department_id,
                        //         'academic_subject_id'=>$subject_id,
                        //         'academic_subject_condition_ids'=>$subConditionIds,
                        //         'academic_class_group_ids'=>$subGroupIds,
                        //         'academic_subject_class_exam_condition_id'=>$val['checkedRadio'],
                        //         'exam_dependent_academic_subject_id'=>$val['exam_dependent_academic_subject_id'],
                        //         'subject_code'=>$subject_code,
                        //         'subject_position'=>$val['subject_position']??0,
                        //         'result_show_in_table_bellow'=>$val['result_show_in_table_bellow']??false,
                        //         'status'=>true,
                        //     ]);

                        // }
// >>>>>>> master


                    //   }
                    // }
                           ///=== site condition end====


                }else{
                    $unchecked_subject_ids[] = $val['id'];
                }

                }

               //  foreach($request->site_ids as $key=>$site_id){

// <<<<<<< HEAD
//                 //     GlobalSubjectGroupConditionSetting::where('academic_group_id', $academic_group_id)
//                 //     ->where('site_id', $site_id)
//                 //     ->whereIn('academic_subject_id', $unchecked_subject_ids)
//                 //     ->where('academic_class_id', $class_id)
//                 //     ->where('academic_year_id', $year_id)
//                 //     ->when($department_id, function ($query) use ($department_id) {
//                 //         return $query->where('academic_department_id', $department_id);
//                 //     })
//                 //     ->update(['status'=>false]);
                  
//                 // }
// =======
                //     GlobalSubjectGroupConditionSetting::where('academic_group_id', $academic_group_id)
                //     ->where('site_id', $site_id)
                //     ->whereIn('academic_subject_id', $unchecked_subject_ids)
                //     ->where('academic_class_id', $class_id)
                //     ->where('academic_year_id', $year_id)
                //     ->when($department_id, function ($query) use ($department_id) {
                //         return $query->where('academic_department_id', $department_id);
                //     })
                //     ->update(['status'=>false]);

                // }


                SiteGroupSubjectGroupConditionSettingStore::whereIn('academic_subject_id', $unchecked_subject_ids)
                ->where('academic_class_id', $class_id)
                ->where('academic_year_id', $year_id)
                ->when($department_id, function ($query) use ($department_id) {
                    return $query->where('academic_department_id', $department_id);
                })
                ->update(['status'=>false]);

            $subject_names = implode(',', $checked_subject_names);

            return Response::json(['message' => $subject_names . ' ' . $edit_mode . ' Successfully!']);

            }

        }


            //==================Subject Limit===============

       public function getSiteGroupGroupSectionBaseSubjectLimit(Request $request){

        $data = $request->all();

        $site_group_id=Session::get('SITE_GROUP_ID');
        $academic_group_id=Session::get('ACADEMIC_GROUP_ID');
     //   dd($academic_group_id);
        $check_group_present=SiteGroupShiftClassGroupSectionSettingStore::where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
             ->when($data['academic_department_id'], function ($query) use ($data) {
                 return $query->where('academic_department_id', $data['academic_department_id']);
             })
           //  ->pluck('academic_class_id')
             ->pluck('academic_class_group_id')
             ->unique()
            ->filter();


        $academic_exam_condition_ids = AcademicSubjectClassExamCondition::whereIn('name_key', ['onlyforexam', 'forclassandexam'])
            ->pluck('id');


        $get_subject_condition=SiteGroupSubjectGroupConditionSettingStore::with(['academicSubject'])
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->whereIn('academic_subject_class_exam_condition_id', $academic_exam_condition_ids)
            ->select('id','academic_subject_condition_ids', 'academic_class_group_ids', 'academic_subject_id')
//            ->where('academic_class_group_ids', '!=', '')
            ->where('status',true)
            ->get();



            if(count($get_subject_condition)<=0){
                return Response::json(['message' => 'Make Sure Academic Subject Condition'],401);

            }

        $present_limit_data=SiteGroupSiteSubjectConditionLimitStore::where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->get();



        $sub_con_list=Array();
        $sub_condition_array=[];
        $count=0;
        foreach ($get_subject_condition as $key => $value) {

            if($value->academic_subject_condition_ids){

                foreach ($value->academic_subject_conditions as $keys => $values) {

                    if($values->condition_key=='optional' || $values->condition_key=='selectiveCompulsory' ||
                        $values->condition_key=='selectiveMarkingless'){

                        if(count($value->academic_class_groups)>0){
                            foreach ($value->academic_class_groups as $keyst => $valuest) {
                                $sub_con_list['condition_id']=$values->id;
                                $sub_con_list['condition_key']=$values->condition_key;
                                $sub_con_list['name']=$values->name;
                                $sub_con_list['group_name']=$valuest->group_name;
                                $sub_con_list['group_id']=$valuest->id;

                                $sub_con_list['id']=$value->id;
                                $sub_con_list['subject_name']=$value->subject_name;
                                $sub_con_list['academic_subject_id']=$value->academic_subject_id;

                                $sub_condition_array[$count]=$sub_con_list;
                                $count++;
//                                continue;
                            }
                        }
                        else{
                            $sub_con_list['condition_id']=$values->id;
                            $sub_con_list['condition_key']=$values->condition_key;
                            $sub_con_list['name']=$values->name;
                            $sub_con_list['group_name']=null;
                            $sub_con_list['group_id']=null;

                            $sub_con_list['id']=$value->id;
                            $sub_con_list['subject_name']=$value->subject_name;
                            $sub_con_list['academic_subject_id']=$value->academic_subject_id;

                            $sub_condition_array[$count]=$sub_con_list;
                            $count++;
//                            continue;
                        }




                    }
                    else{
                        $sub_con_list['condition_id']=0;
                        $sub_con_list['condition_key']=null;
                        $sub_con_list['name']=null;
                        $sub_con_list['group_name']=null;
                        $sub_con_list['group_id']=null;

                        $sub_con_list['id']=$value->id;
                        $sub_con_list['subject_name']=$value->subject_name;
                        $sub_con_list['academic_subject_id']=$value->academic_subject_id;

                        $sub_condition_array[$count]=$sub_con_list;
                        $count++;
//                        continue;
                    }

                }
            }
            else{
                $sub_con_list['condition_id']=0;
                $sub_con_list['condition_key']=null;
                $sub_con_list['name']=null;
                $sub_con_list['group_name']=null;
                $sub_con_list['group_id']=null;

                $sub_con_list['id']=$value->id;
                $sub_con_list['subject_name']=$value->subject_name;
                $sub_con_list['academic_subject_id']=$value->academic_subject_id;

                $sub_condition_array[$count]=$sub_con_list;
                $count++;
//                continue;
            }

        }
    //    dd($sub_condition_array);


        $condition_group_list=collect($sub_condition_array)->where('condition_key', '!=', null);
        $academic_subject_condition=$this->subjectCondition->get();


        $condition_arr=Array();
        $condition_array=[];

       // dd($check_group_present);

        if(count($check_group_present)>0){

            foreach ($check_group_present as $key => $value) {

                $check_sub=$condition_group_list->where('group_id', $value)->values();


                if(count($check_sub)>0){
                    $first_data=$check_sub->first();


                    $condition_arr['id']=$value;
                    $condition_arr['group_name']=$first_data['group_name'];



                    $present_optional_limit=$present_limit_data
                        ->where('academic_class_group_id', $value)
                        ->whereIn('academic_subject_condition_id', $academic_subject_condition
                        ->where('condition_key', 'optional')->pluck('id'))
                        ->first();


                    $check_optional=$check_sub->where('condition_key', 'optional')->values();
                    if(count($check_optional)>0){
                        $condition_arr['optional_sub_limit']=$present_optional_limit?$present_optional_limit->limit_amount:1;
                        $condition_arr['select_optional_subject']=$present_optional_limit?
                            array_map('intval', explode(',', $present_optional_limit->not_show_academic_subject_ids)):[];
                        $condition_arr['optional_subject_list']=$check_optional;

                    }else{
                        $condition_arr['optional_sub_limit']=null;
                        $condition_arr['select_optional_subject']=[];
                        $condition_arr['subject_list']=[];
                    }



                    $present_compulsory_limit=$present_limit_data
                            ->where('academic_class_group_id', $value)
                        ->whereIn('academic_subject_condition_id', $academic_subject_condition
                        ->where('condition_key', 'selectiveCompulsory')->pluck('id'))
                        ->first();

                    $check_compulsory=$check_sub->where('condition_key', 'selectiveCompulsory')->values();
                    if(count($check_compulsory)>0){
                        $condition_arr['conpulsory_sub_limit']=$present_compulsory_limit?$present_compulsory_limit->limit_amount:1;
                        $condition_arr['compulsory_subject_list']=$check_compulsory;
                        $condition_arr['select_compulsory_subject']=$present_compulsory_limit?
                            array_map('intval', explode(',', $present_compulsory_limit->not_show_academic_subject_ids)):[];
                    }else{
                        $condition_arr['conpulsory_sub_limit']=null;
                        $condition_arr['compulsory_subject_list']=[];
                        $condition_arr['select_compulsory_subject']=[];
                    }

                    $present_markingless_limit=$present_limit_data
                        ->where('academic_class_group_id', $value)
                        ->whereIn('academic_subject_condition_id', $academic_subject_condition
                            ->where('condition_key', 'selectiveMarkingless')->pluck('id'))
                        ->first();

                    $check_markingless=$check_sub->where('condition_key', 'selectiveMarkingless')->values();
                    if(count($check_markingless)>0){
                        $condition_arr['markingless_sub_limit']=$present_markingless_limit?$present_markingless_limit->limit_amount:1;
                        $condition_arr['markingless_subject_list']=$check_markingless;
                        $condition_arr['select_markingless_subject']=$present_markingless_limit?
                            array_map('intval', explode(',', $present_markingless_limit->not_show_academic_subject_ids)):[];
                    }else{
                        $condition_arr['markingless_sub_limit']=null;
                        $condition_arr['markingless_subject_list']=[];
                        $condition_arr['select_markingless_subject']=[];
                    }

                    $condition_array[$key]=$condition_arr;

                }

            }
        }
        else{


            $check_sub=$condition_group_list->values();
            $subjct_list=AcademicSubject::whereIn('id', $check_sub->pluck('academic_subject_id')->unique())->get();
            //dd($check_sub);
            $condition_arr['id']=0;
            $condition_arr['group_name']=null;

            $present_optional_limit=$present_limit_data
                ->whereIn('academic_subject_condition_id', $academic_subject_condition
                    ->where('condition_key', 'optional')->pluck('id'))
                ->first();

            $check_optional=$check_sub->where('condition_key', 'optional')->values();
            if(count($check_optional)>0){
                $condition_arr['optional_sub_limit']=$present_optional_limit?$present_optional_limit->limit_amount:1;
                $condition_arr['select_optional_subject']=$present_optional_limit?
                    array_map('intval', explode(',', $present_optional_limit->not_show_academic_subject_ids)):[];
                $condition_arr['optional_subject_list']=$check_optional;
            }else{
                $condition_arr['optional_sub_limit']=null;
                $condition_arr['select_optional_subject']=[];
                $condition_arr['subject_list']=[];
            }


            $present_compulsory_limit=$present_limit_data
               // ->where('academic_class_group_id', $value)
                ->whereIn('academic_subject_condition_id', $academic_subject_condition
                    ->where('condition_key', 'selectiveCompulsory')->pluck('id'))
                ->first();
              //  dd($present_compulsory_limit);

            $check_compulsory=$check_sub->where('condition_key', 'selectiveCompulsory')->values();
            if(count($check_compulsory)>0){

                $condition_arr['conpulsory_sub_limit']=$present_compulsory_limit?$present_compulsory_limit->limit_amount:1;
                $condition_arr['compulsory_subject_list']=$check_compulsory;
                $condition_arr['select_compulsory_subject']=$present_compulsory_limit?
                    array_map('intval', explode(',', $present_compulsory_limit->not_show_academic_subject_ids)):[];
            }else{
                $condition_arr['conpulsory_sub_limit']=null;
                $condition_arr['compulsory_subject_list']=[];
                $condition_arr['select_compulsory_subject']=[];
            }

            $present_markingless_limit=$present_limit_data
               // ->where('academic_class_group_id', $value)
                ->whereIn('academic_subject_condition_id', $academic_subject_condition
                    ->where('condition_key', 'selectiveMarkingless')->pluck('id'))
                ->first();

            $check_markingless=$check_sub->where('condition_key', 'selectiveMarkingless')->values();
            if(count($check_markingless)>0){

                $condition_arr['markingless_sub_limit']=$present_markingless_limit?$present_markingless_limit->limit_amount:1;
                $condition_arr['markingless_subject_list']=$check_markingless;
                $condition_arr['select_markingless_subject']=$present_markingless_limit?
                    array_map('intval', explode(',', $present_markingless_limit->not_show_academic_subject_ids)):[];

            }else{
                $condition_arr['markingless_sub_limit']=null;
                $condition_arr['markingless_subject_list']=[];
                $condition_arr['select_markingless_subject']=[];
            }

            $condition_array[]=$condition_arr;

        }

        // existing site ids
    if (count($present_limit_data)) {
        $existing_site_ids = GlobalSiteSubjectConditionLimit::whereIn('site_id',$this->siteIds())
            ->where('academic_group_id', $academic_group_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->when($request->academic_department_id, function ($query) use ($request) {
                return $query->where('academic_department_id', $request->academic_department_id);
            })
            ->where('status', true)
            ->groupBy('site_id')
            ->pluck('site_id');
        }else{
            $existing_site_ids=[];
        }


        return response()->json(['subject_condition_array'=>$condition_array, 'site_ids'=>$existing_site_ids]);

        }


    public function createSiteGroupSubjectConditionLimit(Request $request){


        $data = $request->all();

        ////=== site gorup condition start ====
        $checkSiteGroupSubjectConditionList=SiteGroupSiteSubjectConditionLimitStore::where('academic_year_id', $request->academic_year_id)
        ->where('academic_class_id', $request->academic_class_id)
        ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
            return $query->where('academic_department_id', $data['academic_department_id']);
        })
//            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
//                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
//            })
        ->get();


    $present_limit_ids=$checkSiteGroupSubjectConditionList->pluck('id');



    $condition_present_list=collect($request->condition_limit_list);

    $created1=[];
    $present_limit_ids_array=[];

    foreach ($condition_present_list as $key => $value) {

        $group_base_limit_list=$checkSiteGroupSubjectConditionList
            ->when(!empty($value['id']), function ($query) use ($value) {
                return $query->where('academic_class_group_id', $value['id']);
            });

        $not_show_subject_list_optional=null;
        if(count($value['optional_subject_list'])>0){
            $not_show_subject_list_optional= $value['select_optional_subject'];

            $academic_subject_condition_list=collect($value['optional_subject_list'])
                ->first();

            if($group_base_limit_list){
                $check_present_data=$group_base_limit_list
                    ->where('academic_subject_condition_id', $academic_subject_condition_list['condition_id'])
                    ->first();

                if($check_present_data){
                    $present_limit_ids_array[]=$check_present_data->id;
                    $check_present_data->limit_amount=$value['optional_sub_limit'];
                    $check_present_data->not_show_academic_subject_ids=collect($not_show_subject_list_optional)->implode(',');
                    $check_present_data->save();
                }
                else{
                    $created1[] = [
                        'academic_group_id' =>Session::get('ACADEMIC_GROUP_ID'),
                        'site_group_id' =>Session::get('SITE_GROUP_ID'),
                        'academic_year_id' => $request->academic_year_id,
                        'academic_class_id' => $request->academic_class_id,
                        'academic_department_id' => $request->academic_department_id,
                        'academic_class_group_id' => $value['id']?$value['id']:null,
                        'academic_subject_condition_id' => $academic_subject_condition_list?$academic_subject_condition_list['condition_id']:null,
                        'limit_amount' =>$value['optional_sub_limit'],
                        'not_show_academic_subject_ids' => collect($not_show_subject_list_optional)->implode(','),
                        'status' => true,
                      //  'site_id' => Session::get('SITE_ID'),

                    ];
                }
            }
            else{
                $created1[] = [
                    'academic_group_id' =>Session::get('ACADEMIC_GROUP_ID'),
                    'site_group_id' =>Session::get('SITE_GROUP_ID'),
                    'academic_year_id' => $request->academic_year_id,
                    'academic_class_id' => $request->academic_class_id,
                    'academic_department_id' => $request->academic_department_id,
                    'academic_class_group_id' => $value['id']?$value['id']:null,
                    'academic_subject_condition_id' => $academic_subject_condition_list?$academic_subject_condition_list['condition_id']:null,
                    'limit_amount' =>$value['optional_sub_limit'],
                    'not_show_academic_subject_ids' => collect($not_show_subject_list_optional)->implode(','),
                    'status' => true,
                   // 'site_id' => Session::get('SITE_ID'),

                ];
            }

        }


        $not_show_subject_list_compulsory=null;
        if(count($value['compulsory_subject_list'])>0){

            $not_show_subject_list_compulsory=$value['select_compulsory_subject'];

            $academic_subject_condition_list=collect($value['compulsory_subject_list'])
                ->first();

            if($group_base_limit_list){
                $check_present_data=$group_base_limit_list
                    ->where('academic_subject_condition_id', $academic_subject_condition_list['condition_id'])
                    ->first();

                if($check_present_data){

                    $present_limit_ids_array[]=$check_present_data->id;

                    $check_present_data->limit_amount=$value['conpulsory_sub_limit'];
                    $check_present_data->not_show_academic_subject_ids=collect($not_show_subject_list_compulsory)->implode(',');

                    $check_present_data->save();
                }
                else{
                    $created1[] = [
                        'academic_group_id' =>Session::get('ACADEMIC_GROUP_ID'),
                        'site_group_id' =>Session::get('SITE_GROUP_ID'),
                        'academic_year_id' => $request->academic_year_id,
                        'academic_class_id' => $request->academic_class_id,
                        'academic_department_id' => $request->academic_department_id,
                        'academic_class_group_id' => $value['id']?$value['id']:null,
                        'academic_subject_condition_id' => $academic_subject_condition_list?$academic_subject_condition_list['condition_id']:null,
                        'limit_amount' =>$value['conpulsory_sub_limit'],
                        'not_show_academic_subject_ids' => collect($not_show_subject_list_compulsory)->implode(','),
                        'status' => true,
                    ];
                }
            }
            else{
                $created1[] = [
                    'academic_group_id' =>Session::get('ACADEMIC_GROUP_ID'),
                    'site_group_id' =>Session::get('SITE_GROUP_ID'),
                    'academic_year_id' => $request->academic_year_id,
                    'academic_class_id' => $request->academic_class_id,
                    'academic_department_id' => $request->academic_department_id,
                    'academic_class_group_id' => $value['id']?$value['id']:null,
                    'academic_subject_condition_id' => $academic_subject_condition_list?$academic_subject_condition_list['condition_id']:null,
                    'limit_amount' =>$value['conpulsory_sub_limit'],
                    'not_show_academic_subject_ids' => collect($not_show_subject_list_compulsory)->implode(','),
                    'status' => true,
                ];
            }

        }


        $not_show_subject_list_markingless=null;
        if(count($value['markingless_subject_list'])>0){
            $not_show_subject_list_markingless=$value['select_markingless_subject'];

            $academic_subject_condition_list=collect($value['markingless_subject_list'])
                ->first();

            if($group_base_limit_list) {
                $check_present_data = $group_base_limit_list
                    ->where('academic_subject_condition_id', $academic_subject_condition_list['condition_id'])
                    ->first();

                if ($check_present_data) {

                    $present_limit_ids_array[] = $check_present_data->id;

                    $check_present_data->limit_amount = $value['markingless_sub_limit'];
                    $check_present_data->not_show_academic_subject_ids = collect($not_show_subject_list_markingless)->implode(',');

                    $check_present_data->save();
                }
                else {
                    $created1[] = [
                        'academic_group_id' =>Session::get('ACADEMIC_GROUP_ID'),
                        'site_group_id' =>Session::get('SITE_GROUP_ID'),
                        'academic_year_id' => $request->academic_year_id,
                        'academic_class_id' => $request->academic_class_id,
                        'academic_department_id' => $request->academic_department_id,
                        'academic_class_group_id' => $value['id']?$value['id']:null,
                        'academic_subject_condition_id' => $academic_subject_condition_list?$academic_subject_condition_list['condition_id']:null,
                        'limit_amount' =>$value['markingless_sub_limit'],
                        'not_show_academic_subject_ids' => collect($not_show_subject_list_markingless)->implode(','),
                        'status' => true,
                    ];
                }
            }
            else{
                $created1[] = [
                    'academic_group_id' =>Session::get('ACADEMIC_GROUP_ID'),
                    'site_group_id' =>Session::get('SITE_GROUP_ID'),
                    'academic_year_id' => $request->academic_year_id,
                    'academic_class_id' => $request->academic_class_id,
                    'academic_department_id' => $request->academic_department_id,
                    'academic_class_group_id' => $value['id']?$value['id']:null,
                    'academic_subject_condition_id' => $academic_subject_condition_list?$academic_subject_condition_list['condition_id']:null,
                    'limit_amount' =>$value['markingless_sub_limit'],
                    'not_show_academic_subject_ids' => collect($not_show_subject_list_markingless)->implode(','),
                    'status' => true,
                ];
            }

        }

    }


    if(count($present_limit_ids)>0){
        $siteSubjectLimitCheck=array_diff($present_limit_ids->toArray(), $present_limit_ids_array);

        SiteGroupSiteSubjectConditionLimitStore::whereIn('id', $siteSubjectLimitCheck)->delete();
    }

    if(count($created1)>0){
        SiteGroupSiteSubjectConditionLimitStore::insert($created1);
    }
        ////=== site gorup condition end ====

        ////=== site  condition start ====
        $checkSiteSubjectConditionList=GlobalSiteSubjectConditionLimit::where('academic_year_id', $request->academic_year_id)
        ->where('academic_class_id', $request->academic_class_id)
        ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
            return $query->where('academic_department_id', $data['academic_department_id']);
        })
//            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
//                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
//            })
        ->get();

        foreach ($request->site_ids as $key => $site_id) {

        $present_limit_ids=$checkSiteSubjectConditionList->where('site_id', $site_id)->pluck('id');

        $condition_present_list=collect($request->condition_limit_list);

        $created=[];
        $present_limit_ids_array=[];

        foreach ($condition_present_list as $key => $value) {

            $group_base_limit_list=$checkSiteSubjectConditionList->where('site_id', $site_id)
                ->when(!empty($value['id']), function ($query) use ($value) {
                    return $query->where('academic_class_group_id', $value['id']);
                });


            $not_show_subject_list_optional=null;
            if(count($value['optional_subject_list'])>0){
                $not_show_subject_list_optional= $value['select_optional_subject'];

                $academic_subject_condition_list=collect($value['optional_subject_list'])
                    ->first();

                if($group_base_limit_list){
                    $check_present_data=$group_base_limit_list
                        ->where('academic_subject_condition_id', $academic_subject_condition_list['condition_id'])
                        ->first();

                    if($check_present_data){

                        $present_limit_ids_array[]=$check_present_data->id;

                        $check_present_data->limit_amount=$value['optional_sub_limit'];
                        $check_present_data->not_show_academic_subject_ids=collect($not_show_subject_list_optional)->implode(',');

                        $check_present_data->save();
                    }
                    else{
                        $created[] = [
                            'academic_group_id' =>Session::get('ACADEMIC_GROUP_ID'),
                            'academic_year_id' => $request->academic_year_id,
                            'academic_class_id' => $request->academic_class_id,
                            'academic_department_id' => $request->academic_department_id,
                            'academic_class_group_id' => $value['id']?$value['id']:null,
                            'academic_subject_condition_id' => $academic_subject_condition_list?$academic_subject_condition_list['condition_id']:null,
                            'limit_amount' =>$value['optional_sub_limit'],
                            'not_show_academic_subject_ids' => collect($not_show_subject_list_optional)->implode(','),
                            'status' => true,
                            'site_id' => $site_id,
                        ];
                    }
                }
                else{
                    $created[] = [
                        'academic_group_id' =>Session::get('ACADEMIC_GROUP_ID'),
                        'academic_year_id' => $request->academic_year_id,
                        'academic_class_id' => $request->academic_class_id,
                        'academic_department_id' => $request->academic_department_id,
                        'academic_class_group_id' => $value['id']?$value['id']:null,
                        'academic_subject_condition_id' => $academic_subject_condition_list?$academic_subject_condition_list['condition_id']:null,
                        'limit_amount' =>$value['optional_sub_limit'],
                        'not_show_academic_subject_ids' => collect($not_show_subject_list_optional)->implode(','),
                        'status' => true,
                        'site_id' => $site_id
                    ];
                }


            }


            $not_show_subject_list_compulsory=null;
            if(count($value['compulsory_subject_list'])>0){

                $not_show_subject_list_compulsory=$value['select_compulsory_subject'];

                $academic_subject_condition_list=collect($value['compulsory_subject_list'])
                    ->first();


                if($group_base_limit_list){
                    $check_present_data=$group_base_limit_list
                        ->where('academic_subject_condition_id', $academic_subject_condition_list['condition_id'])
                        ->first();

                    if($check_present_data){

                        $present_limit_ids_array[]=$check_present_data->id;

                        $check_present_data->limit_amount=$value['conpulsory_sub_limit'];
                        $check_present_data->not_show_academic_subject_ids=collect($not_show_subject_list_compulsory)->implode(',');

                        $check_present_data->save();
                    }
                    else{
                        $created[] = [
                            'academic_group_id' =>Session::get('ACADEMIC_GROUP_ID'),
                            'academic_year_id' => $request->academic_year_id,
                            'academic_class_id' => $request->academic_class_id,
                            'academic_department_id' => $request->academic_department_id,
                            'academic_class_group_id' => $value['id']?$value['id']:null,
                            'academic_subject_condition_id' => $academic_subject_condition_list?$academic_subject_condition_list['condition_id']:null,
                            'limit_amount' =>$value['conpulsory_sub_limit'],
                            'not_show_academic_subject_ids' => collect($not_show_subject_list_compulsory)->implode(','),
                            'status' => true,
                            'site_id' => $site_id,
                        ];
                    }
                }
                else{
                    $created[] = [
                        'academic_group_id' =>Session::get('ACADEMIC_GROUP_ID'),
                        'academic_year_id' => $request->academic_year_id,
                        'academic_class_id' => $request->academic_class_id,
                        'academic_department_id' => $request->academic_department_id,
                        'academic_class_group_id' => $value['id']?$value['id']:null,
                        'academic_subject_condition_id' => $academic_subject_condition_list?$academic_subject_condition_list['condition_id']:null,
                        'limit_amount' =>$value['conpulsory_sub_limit'],
                        'not_show_academic_subject_ids' => collect($not_show_subject_list_compulsory)->implode(','),
                        'status' => true,
                        'site_id' => $site_id,
                    ];
                }
            }


            $not_show_subject_list_markingless=null;
            if(count($value['markingless_subject_list'])>0){
                $not_show_subject_list_markingless=$value['select_markingless_subject'];

                $academic_subject_condition_list=collect($value['markingless_subject_list'])
                    ->first();

                if($group_base_limit_list) {
                    $check_present_data = $group_base_limit_list
                        ->where('academic_subject_condition_id', $academic_subject_condition_list['condition_id'])
                        ->first();

                    if ($check_present_data) {

                        $present_limit_ids_array[] = $check_present_data->id;

                        $check_present_data->limit_amount = $value['markingless_sub_limit'];
                        $check_present_data->not_show_academic_subject_ids = collect($not_show_subject_list_markingless)->implode(',');

                        $check_present_data->save();
                    }
                    else {
                        $created[] = [
                            'academic_group_id' =>Session::get('ACADEMIC_GROUP_ID'),
                            'academic_year_id' => $request->academic_year_id,
                            'academic_class_id' => $request->academic_class_id,
                            'academic_department_id' => $request->academic_department_id,
                            'academic_class_group_id' => $value['id']?$value['id']:null,
                            'academic_subject_condition_id' => $academic_subject_condition_list?$academic_subject_condition_list['condition_id']:null,
                            'limit_amount' =>$value['markingless_sub_limit'],
                            'not_show_academic_subject_ids' => collect($not_show_subject_list_markingless)->implode(','),
                            'status' => true,
                            'site_id' => $site_id,

                        ];
                    }
                }
                else{
                    $created[] = [
                        'academic_group_id' =>Session::get('ACADEMIC_GROUP_ID'),
                        'academic_year_id' => $request->academic_year_id,
                        'academic_class_id' => $request->academic_class_id,
                        'academic_department_id' => $request->academic_department_id,
                        'academic_class_group_id' => $value['id']?$value['id']:null,
                        'academic_subject_condition_id' => $academic_subject_condition_list?$academic_subject_condition_list['condition_id']:null,
                        'limit_amount' =>$value['markingless_sub_limit'],
                        'not_show_academic_subject_ids' => collect($not_show_subject_list_markingless)->implode(','),
                        'status' => true,
                        'site_id' => $site_id,

                    ];
                }
            }
        }

        if(count($present_limit_ids)>0){
            $siteSubjectLimitCheck=array_diff($present_limit_ids->toArray(), $present_limit_ids_array);
            GlobalSiteSubjectConditionLimit::whereIn('id', $siteSubjectLimitCheck)->delete();
        }

        if(count($created)>0){
            GlobalSiteSubjectConditionLimit::insert($created);
        }
    }

        return Response::json(['message' => 'Save Successfully!', 'mode' => 'Update!'], 200);

    }

}
